<? $version= "0.0.1"; ?>
<html>
<head>
<title>Delay Loop Gen / PHP</title>
<style>
body { font-family: "Arial,helvetica";
}
td { font-family: "Arial,helvetica";
     valign: top;
}
</style>
</head>
<body>
<?
  // there's one global var (evil):
  $LABEL_NUMBER = 0;

  include("dlg02_html.php");
  include("dlg02_coder.php");


  // Compatibility section: ------------------------------------------------
  if ( (!isset($_POST)) && (isset($HTTP_POST_VARS)) ) {
    $_POST = $HTTP_POST_VARS;  // compatible to old php interpreters
  }
  if ( (!isset($_GET)) && (isset($HTTP_GET_VARS)) ) {
    $_GET = $HTTP_GET_VARS;  // compatible to old php interpreters
  }
  // -----------------------------------------------------------------------


  // -- Configuration: ----------------------------------

  if (isset($_GET["lang"])) {
    $lang = $_GET["lang"];
  }
  elseif (isset($_POST["lang"])) {
    $lang = $_POST["lang"];
  }

  $config = array();

  //Deutsche Texte:
  $config["de"] = array(
       "HEADLINE"   => "Delay Loop Generator / PHP (de)",
       "CPUSPEED"   => "Prozessor-Speed:",
       "DELAYTIME"  => "Delay time:",
       "REGISTERS"  => "Zu verwendende Register:",
       "OKBUTTON"   => "&nbsp;&nbsp;Code erzeugen&nbsp;&nbsp;",
       "RESULTCODE" => "Erzeugter Code:",
       "CALLMETHOD" => "Aufruf-Methode:",
       "PC_WIDTH"   => "Bitbreite des Program-Counters (PC):",
  );

  if (! in_array( $lang, array_keys( $config ))) {
    $lang = "de";
  }

  // ----------------------------------------------------

  $txt = isset( $config[ $lang ] ) ? $config[ $lang ] : $config[ "de" ];

  // get vars from $_POST: --------------------------------------------
  $cpuspeed_type   = $_POST["cpuspeed_type"  ];
  $cpuspeed_select = $_POST["cpuspeed_select"];
  $cpuspeed_entry  = $_POST["cpuspeed_entry" ];
  if (! in_array($cpuspeed_type, array('entry', 'select'))) {
     $cpuspeed_type = "select";
  }

  // DELAYTIME:
  $delaytime_type  = $_POST["delaytime_type"];
  if (! in_array($delaytime_type, array('entry1', 'entry2'))) {
    $delaytime_type = "entry1";
  }
  $delaytime_entry = $_POST["delaytime_" . $delaytime_type ];


  // REGISTERS:
  $registers = array();
  $count_registers = 0;
  for ($i = 0; $i < 32; $i++ ) {
    if ( isset($_POST["register_R$i"]) ) {
      $registers[] = "R$i";
      $count_registers += 1;
    }
  }


  $callmethod = $_POST["callmethod"];
  if (! in_array( $callmethod, array('rcall', 'nocall'))) {
    $callmethod = "rcall";
  }

  $pcwidth = (int)$_POST["pcwidth" ];
  if (! ( ($pcwidth==16) || ($pcwidth=22))) {
    $pcwidth=16;
  }
  // --------------------------------------------------------------------


  // this function will reside in dlg02_coder.php, later.
  function burn_cycles( $num ) {
    global $count_registers;
    $gewinn = 0;

    // Level2:  Y/3 = s(z+1) : exakt bei: 3teilbar, mind.6 bei smz: 1..256
    if (($gewinn == 0) && ( $num > 768)) {
      $gewinn = burn_level_2( $num );
    }

    if (($gewinn == 0) && ($num > 10)) {
      $gewinn = burn_level_1( $num );
    }

    if ($gewinn == 0) {
      if ($num < 10) {
        $gewinn = burn_level_0( $num );
      }
    }
    return $gewinn;
  }


/*
 Layout:
 
 +--------------+
 | Form |  Code |
 |      |       |
 |      |       |
 |      |       |
 |      |       |
 +--------------+

*/
?>
<table><tr>
<td valign=top>
<?
include("dlg02_form.php");
?>
</td>
<td valign=top>
<?
if (isset($_POST["action"])) {

  print "<b>" . $txt["RESULTCODE"] . "</b>\n";
  print "<pre>";
  printCommentLine( "avr delay loop generator V $version" );
  printCommentLine( "feel free to use the generated code." );
  printCommentLine( "------------------------------------" );


  // ----------------------------------------------------
  // ----------------------------------------------------------------------------
  // main program starts here: --------------------------------------------------


  $cpuspeed_value = $cpuspeed_type == "select" ? $cpuspeed_select : $cpuspeed_entry;
  $cpuspeed       = false;

  if (preg_match( "/^(\d[0-9.]*)\s*(MHz)?/i" , $cpuspeed_value, $matches )) {
    $cpuspeed = (float)$matches[1];
    // print "$cpuspeed<br>\n";
    if (isset( $matches[2] )) {
      $cpuspeed *= 1000000;
    }
    // $cpuspeed = round( $cpuspeed );
  }

  printCommentLine( "CPUSPEED = $cpuspeed [1/sec]" );


  // time to burn:

  // way #1:
  $time_to_burn = 0.0; // [sec]

  // convert a string like 5s65ms to a sec-Value:
  $tmp = trim( $delaytime_entry );
  if ($delaytime_type == "entry1") {
  while (preg_match("/^([0-9][0-9.]*)([hmsu]+)/i", $tmp, $matches )) {
    $number   = (float)$matches[1];
    $timename = $matches[2];
    if     ($timename == "us") {
      $number = $number / 1000000.0;
    }
    elseif ($timename == "ms") {
      $number = $number / 1000.0;
    }
    elseif ($timename == "m") {
      $number = $number * 60.0;
    }
    elseif ($timename == "h") {
      $number = $number * 3600.0;
    }
    elseif ($timename == "s") {
      $number = $number;
    }
    else {
      print "unknown time format in '$tmp'.<br>\n";
      return 0;
    }
    $time_to_burn += $number;
    $tmp = substr( $tmp, strlen($matches[1] . $matches[2]) );
  }
  printCommentLine( "time to delay: $time_to_burn [sec]" );

  $cycles_to_burn = $time_to_burn * $cpuspeed;
  $cycles_to_burn = (int)round( $cycles_to_burn );
  }
  else {
    $cycles_to_burn = (int)$tmp;
    if ($cpuspeed > 0) {
      $time_to_burn   = $cycles_to_burn / $cpuspeed;
      printCommentLine( "time to delay: $time_to_burn [sec]" );
    }
  }
  printCommentLine( "cycles to delay: " . $cycles_to_burn );

  //$cycles_to_burn = 13;
  //printCommentLine( "<b>test cycles to burn: " . $cycles_to_burn . "</b>");

  if ($time_to_burn > 0.05) {
    printCommentLine( "");
    printCommentLine( "Sorry, but this online version calculates");
    printCommentLine( "only loops with up to 0.05 seconds.");
    exit();
  }


  // zu verbratende Zyklen coden:

  printCommentLine("");

  $minus1 = num_start_code_cycles( $cycles_to_burn );
  $minus2 = num_end_code_cycles( $cycles_to_burn );

  printCommentLine("$minus1, $minus2");

  $cycles_to_burn = $cycles_to_burn - $minus1 - $minus2;

  printCommentLine( "cycles to delay: " . $cycles_to_burn . " + $minus1 + $minus2" );


  burn_start_code( $cycles_to_burn );
  $maxiter = 30;
  while (( $cycles_to_burn > 0 ) && ($maxiter > 0)) {
    printCodeLine( "", "", "cycles to do = $cycles_to_burn");
    $gewinn = burn_cycles( $cycles_to_burn );
    printCodeLine( "", "", "gain = $gewinn");
    $cycles_to_burn -= $gewinn;
    $maxiter -= 1;
  }
  burn_end_code( $cycles_to_burn );

  ?></textarea></form><?

  if ($maxiter <= 0) {
    print "<h1><font color=red>Iteration overflow!</font></h1>";
  }
} // action
else {
  print "&nbsp;\n";
}
  // ----------------------------------------------------------------------------
?>
</pre>
</td>
</tr></table>

</body>
</html>
