#!/usr/bin/python

"""
2001-10-13 : I have to change the zoom mode:
	I uses a top-left-point, a gfx width and height, and zoom.
	when zooming, the redrawed picture moves...
	I have to use a FIXED point.


TO DO: (29.08.2001)

ATTENTION:
probably I should modify getWORD to return negative values..?
now there's a second function, called "getSignedWord(..)".

--> 999 it just calls getWord() by now!!! 999 <--

RST processing:
- Winplan Data Section
- Extended Ufo Database
DONE: - Section 8: VCRs  2001-AUG-31 (before lunch)
DONE: - starbaseclass.py: reading _all_ attributes  2001-AUG-31 21:58:54 tk
DONE: - planetclass.py  : reading _all_ attributes  2001-AUG-31
DONE: - shipclass.py    : reading _all_ attributes  2001-AUG-31 12:00:00 tk

TRN generation:
- missing

convenience functions:
- transferCargoFromShip(shipid, target....) // something like that
- ship.setPlanetTarget( planetID ) // !?
...

GUI:
- working on the gui for some weeks now...

"""

from math import *
import rawdata

from shipclass          import ShipClass
from planetclass        import PlanetClass
from starbaseclass      import StarbaseClass
from shipcoordsclass    import ShipCoordsClass
from messageclass       import MessageClass
from visualcontactclass import VisualContactClass
import vcrclass
import pickle

from xyplanclass import XYPlanClass

# fuer die GUI:
import sys
import libglade
from gtk import *


class MainApp(rawdata.rawdata):

  def __init__( self ):
    self.shipVec      = {}
    self.planetVec    = {}
    self.starbaseVec  = {}
    self.shipCoordVec = {}
    self.visualContactVec = {}
    self.battleVec    = {}
    self.xyplanVec    = {}   # xyplant.dat merged with planets.nm

    self.loadProgramData();

    self.lastObjectType = 1    # 1 = planets, 2 = ships, besser wren Konstanten o..
    self.lastPlanetID = -1   # ID des zuletzt selektierten Planeten
    self.lastShipID   = -1   # selbiges fr Schiffe

    self.gfx_width = 530
    self.gfx_height= 480
    self.gfx_cx, self.gfx_cy    = 2500, 1500  # the star map center I look at.
    self.gfx_zoom               = 2           # [rx, rx + zoom*width]...

    #
    self.initGUI('plynets1.glade');
    self.loadStaticPlanetsData('dat/xyplan.dat', 'dat/planet.nm')
    mainloop()

  # gui methods:

  def mainloop(self):
    mainloop();  # gtk.mainloop(()

  def initGUI( self, gladeFilename ):
    self.xml = libglade.GladeXML( gladeFilename )
    self.pixmap = None
    drawing_area = self.xml.get_widget('drawingarea1')
    self.drawingarea = drawing_area;
    drawing_area.connect("expose_event",       self.on_drawingarea1_expose_event)
    drawing_area.connect("configure_event",    self.on_drawingarea1_configure_event)
    drawing_area.connect("button_press_event", self.on_drawingarea1_button_press_event)
    drawing_area.add_events(GDK.EXPOSURE_MASK | GDK.LEAVE_NOTIFY_MASK | GDK.BUTTON_PRESS_MASK )

    # buttons:
    self.xml.signal_connect('close_window', mainquit)

    # scroll the star map:
    self.xml.signal_connect('on_scrollLeft_clicked' , self.on_scrollLeft_clicked, 1)
    self.xml.signal_connect('on_scrollRight_clicked', self.on_scrollRight_clicked, 1)
    self.xml.signal_connect('on_scrollUp_clicked'   , self.on_scrollUp_clicked, 1)
    self.xml.signal_connect('on_scrollDown_clicked' , self.on_scrollDown_clicked, 1)

    # ein Knopf auf der Planeten-Kladde, um die Map zu zentrieren:
    self.xml.signal_connect('on_center_map', self.on_center_map, 1)

    # zoom into the map:
    self.xml.signal_connect('on_zoomMore_clicked', self.on_zoomMore_clicked, 1)
    self.xml.signal_connect('on_zoomLess_clicked', self.on_zoomLess_clicked, 1)
    # self.xml.signal_connect("on_redraw_clicked"   , self.on_redraw_clicked   , 1 )

    # menues:
    self.xml.signal_connect("on_rst_laden1_activate", self.on_rst_laden1_activate, 1 )
    # self.xml.signal_connect("on_daten_speichern1_activate", self.on_program_end, 1)
    # self.xml.signal_connect('on_ende1_activate', mainquit)
    self.xml.signal_connect("on_ende1_activate", self.on_program_end, 1)
    self.xml.signal_connect("on_daten_speichern1_activate", self.on_program_end, 1)
  # 1------------7------------7------------7------------7------------7------------7------------7

  def on_program_end( self, widget, event ):
    self.saveProgramData()
    mainquit()

  # E X P O S E - E V E N T:

  def on_drawingarea1_expose_event(self, drawingarea, event):
    # print "expose event"
    if self.pixmap == None:
      self.on_drawingarea1_configure_event(drawingarea, event)
    if self.pixmap == None:
      print "Fehler: self.pixmap == None"
      exit

    window = event.window
    gc = window.new_gc()    # graphics context
    black  = drawingarea.get_colormap().alloc(0x0000, 0x0000, 0x0000)
    white  = drawingarea.get_colormap().alloc(0xFFFF, 0xFFFF, 0xFFFF)
    green  = drawingarea.get_colormap().alloc(0x0000, 0xFFFF, 0x0000)
    yellow = drawingarea.get_colormap().alloc(0xFFFF, 0xFFFF, 0x0000)
    lila   = drawingarea.get_colormap().alloc(0xFFFF, 0x9999, 0xFFFF)
    red    = drawingarea.get_colormap().alloc(0xFFFF, 0x0000, 0x0000)

    # first "clear" the area:
    gc.foreground = black
    drawingarea.draw_rectangle(gc, TRUE, 0, 0, self.gfx_width, self.gfx_height)


    # next: draw all visible planets according to gfx_zoom:
    gc.foreground = white
    font = load_font("-*-helvetica-medium-r-normal-*-*-100-*-*-*-*-*-*")

    # we have to detect whether a planet has to be drawn:
    realityWidth  = self.gfx_width  * self.gfx_zoom
    realityHeigth = self.gfx_height * self.gfx_zoom

    xmin = self.gfx_cx - (realityWidth / 2)  # coords on the map
    ymin = self.gfx_cy - (realityHeigth / 2)
    xmax = self.gfx_cx + (realityWidth / 2)
    ymax = self.gfx_cy + (realityHeigth / 2)

    # this version assumes 500 planets (old vgaplanets).
    for i in range(500):
      planetID = i + 1   # goes from 1 upto 500
      xyref = self.xyplanVec[ planetID ]  # xy-coordinates and names of all planets.
      x,y = xyref.x, xyref.y

      if ((x >= xmin) and (x <= xmax) and (y >= ymin) and (y <= ymax)):
        # now we have to calculate back where to draw the planet:
        dx = (x - xmin) / self.gfx_zoom
        dy = (y - ymin) / self.gfx_zoom
	dy = self.gfx_height - dy
        drawingarea.draw_string(font, gc, dx, dy-2, xyref.name)
	if planetID in self.planetVec.keys():
	  gc.foreground = yellow
	else:
          gc.foreground = white
        drawingarea.draw_string(font, gc, dx, dy-2, xyref.name)
        drawingarea.draw_rectangle(gc, TRUE, dx-1, dy-1, 3, 3)

    # for in in range 500...

    # next: drawing all known ships: (what about ships in orbits?)
    for shipID in self.shipCoordVec.keys():
      shipCoords = self.shipCoordVec[ shipID ]
      x,y = shipCoords.x, shipCoords.y
      owner = shipCoords.owner

      if ((x >= xmin) and (x <= xmax) and (y >= ymin) and (y <= ymax)):
        # now we have to calculate back where to draw the ship (orbits???)
        dx = (x - xmin) / self.gfx_zoom
        dy = (y - ymin) / self.gfx_zoom
	dy = self.gfx_height - dy

        if shipID in self.shipVec.keys():
	  myShip = self.shipVec[ shipID ]
	  distX, distY = myShip.oldData.distX, myShip.oldData.distY
          mapX = x + distX
          mapY = y + distY
          drawingX = (mapX - xmin) / self.gfx_zoom
          drawingY = (mapY - ymin) / self.gfx_zoom
          drawingY = self.gfx_height - drawingY

	  gc.foreground = lila  # my own ship
	  # drawingarea.draw_string(font, gc, dx, dy-2, myShip.getName())
	  drawingarea.draw_rectangle(gc, FALSE, dx-3, dy-3, 6, 6)
	  drawingarea.draw_line(gc, dx, dy, drawingX, drawingY)
	else:
	  gc.foreground = red   # other ships (enemy?)
          drawingarea.draw_rectangle(gc, TRUE, dx-1, dy-1, 3, 3)


    # end of drawings

  # 1------------7------------7------------7------------7------------7------------7------------7

  def on_drawingarea1_configure_event(self, widget, event):
    # print "configure event"
    if self.pixmap == None:
      win = widget.get_window()
      self.pixmap = create_pixmap(win, self.gfx_width, self.gfx_height, -1)
      print "created pixmap"
    if self.pixmap != None:
      draw_rectangle(self.pixmap, widget.get_style().black_gc, TRUE, 0, 0, 400, 400)
    else:
      print "Fehler: Pixmap == None!"
    return TRUE


  def draw_brush(self,  widget, x, y):
    rect = (x-4, y-4, 8, 8)
    draw_rectangle(self.pixmap, widget.get_style().white_gc, TRUE,
                       x-4, y-4, 8, 8)
    widget.queue_draw()

  # -------------------

  def on_drawingarea1_button_press_event(self,  widget, event):
    # print "button_press_event"

    x = event.x
    y = event.y
    mapX = self.gfx_cx - (((self.gfx_width  / 2) - x) * self.gfx_zoom)
    mapY = self.gfx_cy + (((self.gfx_height / 2) - y) * self.gfx_zoom)

    minDelta  = 3000.0 # fuer die Suche nach dem nahesten Objekt
    merkID = -1
    merkName = "bla fasel"

    if event.button == 1:  # planet auswaehlen
      # nun suchen wir den nchstliegendsten Planeten:
      for i in range(500):
	  id = i + 1
	  planet = self.xyplanVec[ id ]
	  deltaX = planet.x - mapX
	  deltaY = planet.y - mapY
	  delta  = sqrt( deltaX * deltaX  + deltaY * deltaY )
	  if delta < minDelta:
		minDelta = delta
		merkID   = id
		merkName = planet.name

      print "Naechster Planet: ", merkName, " (", merkID, ")"
      self.lastPlanetID = merkID
      self.showPlanetData( merkID )
      self.lastObjectType = 1

    if event.button == 3:  # schiff auswaehlen
      anyShip = 0
      for shipCoordsID in self.shipCoordVec.keys():
          anyShip = 1
	  coords = self.shipCoordVec[ shipCoordsID ]
	  deltaX = coords.x - mapX
	  deltaY = coords.y - mapY
	  delta  = sqrt( deltaX * deltaX  + deltaY * deltaY )
	  if delta < minDelta:
		minDelta = delta
		merkID   = shipCoordsID

      if merkID in self.shipVec.keys():  # eigenes Schiff?
          ship = self.shipVec[ merkID ]
          print "Naechstes Schiff (noch nicht mehrere): ", ship.getName(), merkID
          self.lastShipID = merkID
          self.lastObjectType = 2
          self.showShipData( merkID )
      else:
          if anyShip == 0:
            print "Kein Schiff vorhanden."
          else:
            print "Fremdes Schiff, Owner=",coords.getOwner(), merkID
            self.lastShipID = merkID
            self.lastObjectType = 2
            self.showShipData( merkID )

    return TRUE

  # -------------------

  def on_rst_laden1_activate(self,  widget, event):
    print "menu event: rst laden"
#    self.loadRST('rst20010827')
#    self.loadRST('rst20010927');
#    self.loadRST('rst20011021');
#    self.loadRST('rst20011026A');
#    self.loadRST('rst20011101');
    self.loadRST('rst20020106')
#   drawingarea = self.xml.get_widget('drawingarea1')
    self.drawingarea.queue_draw()

  def drawPlanet(self, x,y, r):
    #widget = self.xml.get_widget('drawingarea1')
    draw_rectangle(self.pixmap, self.drawingarea.get_style().white_gc, TRUE,
                       x-r, y-r, 2*r, 2*r)
    self.drawingarea.queue_draw()

  # --------------------------------------------------
  # Scroll-Buttons: (StarMap)

  def on_scrollLeft_clicked( self, widget, event ):
    self.gfx_cx = self.gfx_cx - ((self.gfx_zoom * self.gfx_width) / 15)
    # drawingarea = self.xml.get_widget('drawingarea1')
    self.drawingarea.queue_draw()

  def on_scrollRight_clicked( self, widget, event ):
    self.gfx_cx = self.gfx_cx + ((self.gfx_zoom * self.gfx_width) / 15)
    # drawingarea = self.xml.get_widget('drawingarea1')
    self.drawingarea.queue_draw()

  def on_scrollUp_clicked( self, widget, event ):
    self.gfx_cy = self.gfx_cy + ((self.gfx_zoom * self.gfx_height) / 15)
    # drawingarea = self.xml.get_widget('drawingarea1')
    self.drawingarea.queue_draw()

  def on_scrollDown_clicked( self, widget, event ):
    self.gfx_cy = self.gfx_cy - ((self.gfx_zoom * self.gfx_height) / 15)
    # drawingarea = self.xml.get_widget('drawingarea1')
    self.drawingarea.queue_draw()


  def on_center_map( self, widget, event ):
    if self.lastObjectType == 1:         # letztes Objekt war ein Planet
      planetID = self.lastPlanetID
      if planetID != -1:
        planet = self.xyplanVec[ planetID ]
        self.gfx_cx = planet.x
        self.gfx_cy = planet.y
        self.drawingarea.queue_draw()

    if self.lastObjectType == 2:         # letztes Objekt war ein Schiff
      shipID = self.lastShipID
      if shipID != -1:
        shipCoords = self.shipCoordVec[ shipID ]
        self.gfx_cx, self.gfx_cy = shipCoords.x, shipCoords.y
        self.drawingarea.queue_draw()


  # --------------------------------------------------
  # ZOOM-Buttons:

  def on_zoomMore_clicked( self, widget, event ):
    self.gfx_zoom = self.gfx_zoom / 1.2
    print "neuer zoom: ",self.gfx_zoom
    # drawingarea = self.xml.get_widget('drawingarea1')
    self.drawingarea.queue_draw()

  def on_zoomLess_clicked( self, widget, event ):
    self.gfx_zoom = self.gfx_zoom * 1.2
    print "neuer zoom: ",self.gfx_zoom
    # drawingarea = self.xml.get_widget('drawingarea1')
    self.drawingarea.queue_draw()


  # the next gui function aktualisiert the gui elements showing planetary data:
  def showPlanetData( self, planetID ):
    print "in showPlanetData( ", planetID, ")"
    combo = self.xml.get_widget('comboPlanetSelectorEntry')
    xyplanet = self.xyplanVec[ planetID ]
    combo.set_text( xyplanet.name )
    if self.planetVec.has_key( planetID ):
      planet = self.planetVec[ planetID ]
      minedOre  = planet.oldData.minedOre
      groundOre = planet.oldData.groundOre
      den       = planet.oldData.oreDensity

      self.xml.get_widget('labelPlanetXY'  ).set_text( 'X=' + str( xyplanet.x ) + ' / Y=' + str(xyplanet.y) )
      self.xml.get_widget('labelPlanetTemp').set_text( str( planet.oldData.temperature ) + '' )

      self.xml.get_widget('labelPlanetSupplies').set_text( str( planet.newData.supplies ))
      self.xml.get_widget('labelPlanetMC').set_text( str( planet.newData.credits ))

      # Surface
      self.xml.get_widget('labelPlanetSurfaceN').set_text( str( minedOre.n ))
      self.xml.get_widget('labelPlanetSurfaceD').set_text( str( minedOre.d ))
      self.xml.get_widget('labelPlanetSurfaceT').set_text( str( minedOre.t ))
      self.xml.get_widget('labelPlanetSurfaceM').set_text( str( minedOre.m ))

      # Ground
      self.xml.get_widget('labelPlanetGroundN').set_text( str( groundOre.n ))
      self.xml.get_widget('labelPlanetGroundD').set_text( str( groundOre.d ))
      self.xml.get_widget('labelPlanetGroundT').set_text( str( groundOre.t ))
      self.xml.get_widget('labelPlanetGroundM').set_text( str( groundOre.m ))

      # Density
      self.xml.get_widget('labelPlanetDensityN').set_text( str( den.n ) + '%' )
      self.xml.get_widget('labelPlanetDensityD').set_text( str( den.d ) + '%' )
      self.xml.get_widget('labelPlanetDensityT').set_text( str( den.t ) + '%' )
      self.xml.get_widget('labelPlanetDensityM').set_text( str( den.m ) + '%' )

      # Trend:
      miningFactor = planet.oldData.race.getMiningFactor() # reptilians: 2, else 1
      n = planet.newData.numMines * miningFactor * den.n * self.miningRate() / 10000             # 999 feds
      t = planet.newData.numMines * miningFactor * den.d * self.miningRate() / 10000             # 999 feds
      d = planet.newData.numMines * miningFactor * den.t * self.miningRate() / 10000             # 999 feds
      m = planet.newData.numMines * miningFactor * den.m * self.miningRate() / 10000             # 999 feds
      if n > groundOre.n:
        n = groundOre.n
      if d > groundOre.d:
        d = groundOre.d
      if t > groundOre.t:
        t = groundOre.t
      if m > groundOre.m:
        m = groundOre.m
      self.xml.get_widget('labelPlanetNextN').set_text( '+' + str( n ) )
      self.xml.get_widget('labelPlanetNextD').set_text( '+' + str( d ) )
      self.xml.get_widget('labelPlanetNextT').set_text( '+' + str( t ) )
      self.xml.get_widget('labelPlanetNextM').set_text( '+' + str( m ) )


      self.xml.get_widget('labelPlanetMines').set_text( str( planet.newData.numMines ))
      self.xml.get_widget('labelPlanetFactories').set_text( str( planet.newData.numFactories ))
      self.xml.get_widget('labelPlanetDefenses').set_text( str( planet.newData.numDefenses ))

      # Natives:
      self.xml.get_widget('labelNativeRace'      ).set_text( planet.oldData.race.getName() )
      self.xml.get_widget('labelNativeGov'       ).set_text( planet.oldData.gov.getName()  )
      self.xml.get_widget('labelNativePopulation').set_text( str(100 * planet.oldData.nativeClans) )
      # self.xml.get_widget('spinButtonNativeTax').set_text( str(planet.oldData.nativeHappiness) )
      self.xml.get_widget('labelNativeHappiness' ).set_text( str(planet.oldData.nativeHappiness) )

      # Colonists:
      self.xml.get_widget('labelColPopulation' ).set_text( str( planet.oldData.colonists ) )
      # self.xml.get_widget('spinButtonColTax' ).set_text( str(planet.oldData.nativeHappiness) )
      self.xml.get_widget('labelColHappiness'  ).set_text( str(planet.oldData.colonistHappiness) )

    else:
      self.xml.get_widget('labelPlanetXY').set_text( '- -' )
      self.xml.get_widget('labelPlanetTemp').set_text( '' )

      self.xml.get_widget('labelPlanetSupplies').set_text( '-' )
      self.xml.get_widget('labelPlanetMC').set_text(       '-' )

      self.xml.get_widget('labelPlanetSurfaceN').set_text( '-' )
      self.xml.get_widget('labelPlanetSurfaceD').set_text( '-' )
      self.xml.get_widget('labelPlanetSurfaceT').set_text( '-' )
      self.xml.get_widget('labelPlanetSurfaceM').set_text( '-' )

      self.xml.get_widget('labelPlanetGroundN').set_text( '-' )
      self.xml.get_widget('labelPlanetGroundD').set_text( '-' )
      self.xml.get_widget('labelPlanetGroundT').set_text( '-' )
      self.xml.get_widget('labelPlanetGroundM').set_text( '-' )

      # Density
      self.xml.get_widget('labelPlanetDensityN').set_text( '' )
      self.xml.get_widget('labelPlanetDensityD').set_text( '' )
      self.xml.get_widget('labelPlanetDensityT').set_text( '' )
      self.xml.get_widget('labelPlanetDensityM').set_text( '' )

      # Trend
      self.xml.get_widget('labelPlanetNextN').set_text( '' )
      self.xml.get_widget('labelPlanetNextD').set_text( '' )
      self.xml.get_widget('labelPlanetNextT').set_text( '' )
      self.xml.get_widget('labelPlanetNextM').set_text( '' )


      self.xml.get_widget('labelPlanetMines').set_text( '-' )
      self.xml.get_widget('labelPlanetFactories').set_text( '-' )
      self.xml.get_widget('labelPlanetDefenses').set_text( '-' )

      self.xml.get_widget('labelNativeRace').set_text( '?' )

      # Natives:
      self.xml.get_widget('labelNativeRace'      ).set_text( '' );
      self.xml.get_widget('labelNativeGov'       ).set_text( '' );
      self.xml.get_widget('labelNativePopulation').set_text( '' );
      # self.xml.get_widget('spinButtonNativeTax').set_text( '' );
      self.xml.get_widget('labelNativeHappiness' ).set_text( '' );

      # Colonists:
      self.xml.get_widget('labelColPopulation' ).set_text( '' )
      # self.xml.get_widget('spinButtonColTax' ).set_text( '' )
      self.xml.get_widget('labelColHappiness'  ).set_text( '' )


      count = len(self.planetVec)
      if (count == 0):
        print "Kein RST geladen?"

  # ---------------------------------------------------------------------
  def clearShipDataGui( self ):
    self.xml.get_widget( 'comboShipSelectorEntry1' ).set_text( '' )
    self.xml.get_widget( 'labelShipFuel' ).set_text( '' )
    self.xml.get_widget( 'labelShipPosition' ).set_text( '?' )
    self.xml.get_widget( 'labelShipWaypoint' ).set_text( '?' )
    # ??? self.xml.get_widget( 'spinbuttonShipSpeed' ).set_text( '' )
    self.xml.get_widget( 'labelShipETA' ).set_text( '' )

    self.xml.get_widget( 'labelShipCargoNShip'   ).set_text( '' )
    self.xml.get_widget( 'labelShipCargoNTarget' ).set_text( '' )

    self.xml.get_widget( 'labelShipCargoDShip'   ).set_text( '' )
    self.xml.get_widget( 'labelShipCargoDTarget' ).set_text( '' )

    self.xml.get_widget( 'labelShipCargoTShip'   ).set_text( '' )
    self.xml.get_widget( 'labelShipCargoTTarget' ).set_text( '' )

    self.xml.get_widget( 'labelShipCargoMShip'   ).set_text( '' )
    self.xml.get_widget( 'labelShipCargoMTarget' ).set_text( '' )

  # ---------------------------------------------------------------------

  # the next gui function aktualisiert the gui elements showing ship data:
  def showShipData( self, shipID ):
    print "in showShipData( ", shipID, ")"
    self.clearShipDataGui();

    # wenn es ein eigenes Schiff ist, zeige ich die Schiffs-Daten an:
    if shipID in self.shipVec.keys():
      ship = self.shipVec[ shipID ]
      positionID = self.getPlanetIDByWaypoint( ship.oldData.x, ship.oldData.y )
      if positionID > 0:
        position = self.xyplanVec[ positionID ].name
      else:
        position = 'deep space'

      waypointID = self.getPlanetIDByWaypoint( ship.oldData.x + ship.oldData.distX, ship.oldData.y + ship.oldData.distY )
      if (waypointID > 0):
        waypoint = self.xyplanVec[ waypointID ].name
      else:
        waypoint = 'deep space'

      self.xml.get_widget( 'comboShipSelectorEntry1' ).set_text( ship.getName() )
      self.xml.get_widget( 'labelShipFuel' ).set_text( str(ship.newData.cargo.n) )
      self.xml.get_widget( 'labelShipPosition' ).set_text( position )
      self.xml.get_widget( 'labelShipWaypoint' ).set_text( waypoint )
      # 999 self.xml.get_widget( 'spinbuttonShipSpeed' ).set_text( '' )
      self.xml.get_widget( 'labelShipETA' ).set_text( 'irgendwann' )

      self.xml.get_widget( 'labelShipCargoNShip'   ).set_text( str(ship.newData.cargo.n) )
      self.xml.get_widget( 'labelShipCargoNTarget' ).set_text( '??' )

      self.xml.get_widget( 'labelShipCargoDShip'   ).set_text( str(ship.newData.cargo.d) )
      self.xml.get_widget( 'labelShipCargoDTarget' ).set_text( '??' )

      self.xml.get_widget( 'labelShipCargoTShip'   ).set_text( str(ship.newData.cargo.t) )
      self.xml.get_widget( 'labelShipCargoTTarget' ).set_text( '??' )

      self.xml.get_widget( 'labelShipCargoMShip'   ).set_text( str(ship.newData.cargo.m) )
      self.xml.get_widget( 'labelShipCargoMTarget' ).set_text( '??' )

      # fischmarke 999
  # --------------------------------------------------
  # END OF GUI METHODS

  def getPlanetIDByWaypoint( self, wx, wy ):
    for i in range(500):
      planet = self.xyplanVec[ i + 1 ]
      if (planet.x == wx) and (planet.y == wy):
        return i+1
    return -1

  #
  def miningRate( self ):
    return 70   # 999 Feds!
  # ------------------------------------------------------

  def decodePassword( self, pw ):
    return pw
    tmp = ""
    length = len(pw)
    for i in range(length):
      if (ord(pw[i]) > 50):
        tmp = tmp + chr(ord(pw[i]) - 50)
      else:
        tmp = tmp + pw[i]
    return tmp
  #enddef

  def loadStaticPlanetsData( self, xyplanFilename, planetsnmFilename ):
    xyFile = open( xyplanFilename   , "rb" )  # read, binary mode
    nmFile = open( planetsnmFilename, "rb" )  # read, binary mode
    for i in range(500):
      planetIndex = i + 1
      xydata = xyFile.read(  6 )
      nmdata = nmFile.read( 20 )
      xyplanInstance = XYPlanClass( xydata, nmdata )
      self.xyplanVec[ planetIndex ] = xyplanInstance
      # xyplanInstance.dump()
    # endfor
    nmFile.close
    xyFile.close

  def saveProgramData( self ):
    f = open('current/shipVec.ply', 'w');
    pickle.dump( self.shipVec, f )
    f.close()
    f = open('current/planetVec.ply', 'w');
    pickle.dump( self.planetVec, f )
    f.close()
    f = open('current/starbaseVec.ply', 'w');
    pickle.dump( self.starbaseVec, f )
    f.close()
    f = open('current/shipCoordVec.ply', 'w');
    pickle.dump( self.shipCoordVec, f )
    f.close()
    f = open('current/visualContactVec.ply', 'w');
    pickle.dump( self.visualContactVec, f )
    f.close()
    f = open('current/battleVec.ply', 'w');
    pickle.dump( self.battleVec, f )
    f.close()
    f = open('current/xyplanVec.ply', 'w');
    pickle.dump( self.xyplanVec, f )
    f.close()

  def loadProgramData( self ):
    f = open('current/shipVec.ply', 'r');
    self.shipVec = pickle.load( f )
    f.close()
    f = open('current/planetVec.ply', 'r');
    self.planetVec = pickle.load( f )
    f.close()
    f = open('current/starbaseVec.ply', 'r');
    self.starbaseVec = pickle.load( f )
    f.close()
    f = open('current/shipCoordVec.ply', 'r');
    self.shipCoordVec = pickle.load( f )
    f.close()
    f = open('current/visualContactVec.ply', 'r');
    self.visualContactVec = pickle.load( f )
    f.close()
    f = open('current/battleVec.ply', 'r');
    self.battleVec = pickle.load( f )
    f.close()
    f = open('current/xyplanVec.ply', 'r');
    self.xyplanVec = pickle.load( f )
    f.close()


  def loadRST(self,filename):
    self.shipVec     = {}
    self.planetVec   = {}
    self.starbaseVec = {}
    self.shipCoordVec = {}
    self.visualContactVec = {}
    self.battleVec    = {}

    print "reading RST file \"",filename,"\""
    ptrs = {}
    file = open( filename, "rb" )
    # data ptr auslesen:
    for i in range(8):
      print "reading pointer ", i
      # file.seek(i*4)
      data = file.read(4)
      ptr  = self.getDWORD(data, 0)
      ptrs[i+1] = ptr - 1
    # endfor
    # read more header info:
    file.seek(32)
    self.rstSignature = self.getString(file.read(6), 0, 6)
    self.rstSignature = self.rstSignature + self.getString(file.read(2), 0, 2)
    winplanDataPtr    = self.getDWORD(file.read(4), 0)
    leechxDataPtr     = self.getDWORD(file.read(4), 0)

    # print header dat:
    print "RST Signature   : ", self.rstSignature
    print "Winplan Data Ptr: ", winplanDataPtr
    print "LEECHx.DAT   Ptr: ", leechxDataPtr
    print "\nSection Pointers:"
    for i in range(8):
      print "Ptr to section",i+1,"is",ptrs[i+1]

    # section 1: reading ship data:
    if (ptrs[1] > 0):
      file.seek(ptrs[1])
      count = self.getWORD(file.read(2), 0)
      print "\nthere are",count, "ships..."
      for i in range(count):
        print "\nreading ship no.",i+1,":"
        ship = ShipClass( file.read(107) )      # create new ship
        ship.dump()
        # self.gui.testDrawXY( ship.oldData.x , ship.oldData.y )
        self.shipVec[ ship.getID() ] = ship
    else:
      print "Warning: no ship records in RST file?"

    # section 2: visual contacts (34 bytes)
    if (ptrs[2] > 0):
      file.seek(ptrs[2])
      count = self.getWORD(file.read(2), 0)
      print "\nthere are",count, "visual contacts..."
      for i in range(count):
        print "reading visual contact no.",i+1,": ",
        viscontact = VisualContactClass( file.read(34) )      # create new planet
        print "ID:",viscontact.getID(), "Name: ",viscontact.getName()
        self.visualContactVec[ viscontact.getID() ] = viscontact
    else:
      print "Warning: no visual contacts in RST file."


    # section 3: reading planet data:
    if (ptrs[3] > 0):
      file.seek(ptrs[3])
      count = self.getWORD(file.read(2), 0)
      print "\nthere are",count, "planets..."
      for i in range(count):
        print "reading planet no.",i+1,": ",
        planet = PlanetClass( file.read(85) )      # create new planet
        planet.dump()
	print "id des planeten: ",planet.getID()
        self.planetVec[ planet.getID() ] = planet
    else:
      print "Warning: no planet records in RST file."

    # section 4: starbases
    if (ptrs[4] > 0):
      file.seek(ptrs[4])
      count = self.getWORD(file.read(2), 0)
      print "\nthere are",count, "star bases..."
      for i in range(count):
        print "reading star base no.",i+1,": ",
        starbase = StarbaseClass( file.read(156) )      # create new star base
        print "ID:",starbase.getID(), "(= the planet's ID)"
        self.starbaseVec[ starbase.getID() ] = starbase
    else:
      print "Warning: no star bases in RST file."

    print

    # section 5: messages (phost dat files?)
    msgptr_hash = {}
    if (ptrs[5] > 0):
      print "messages not fully implemented yet."
      file.seek(ptrs[5])
      count = self.getWORD(file.read(2), 0)
      print "\nthere are",count, "messages..."
      for i in range(count):
        print "reading message no.",i+1,": ",
        data = file.read(6)
        msg_ptr = self.getDWORD(data,0) - 1
        msg_len = self.getWORD(data,4)
        msgptr_hash[ msg_ptr ] = msg_len
        print "Message at",msg_ptr,", len=",msg_len
    else:
      print "Warning: no messages in RST file."

    for msg_ptr in msgptr_hash.keys():
      msg_len =msgptr_hash[ msg_ptr ]
      file.seek( msg_ptr )
      data = file.read( msg_len )
      msg = MessageClass(data)
      msg.printMessage()
    #endfor

    print

    # section 6: ship coordinates
    if (ptrs[6] > 0):
      file.seek(ptrs[6])
      if ((ptrs[7] - ptrs[6]) == 4000):
        count = 500
      else:
        count = 999
      print "\nthere are",count, "ship coordinates in the rst file..."
      for i in range(count):
        #print "reading ship coords no.",i+1,":"
        shipcoord = ShipCoordsClass( file.read(8) )      # create new ship coords instance
        ship_id   = i + 1
        if ((shipcoord.x != 0) and (shipcoord.y != 0)):
          print "ship coords: id x y owner mass:",ship_id,shipcoord.x,shipcoord.y,shipcoord.owner,shipcoord.mass
          self.shipCoordVec[ ship_id ] = shipcoord
    else:
      print "Warning: no ship coords in RST file."


    # section 7: GENx.DAT
    if (ptrs[7] > 0):
      file.seek(ptrs[7])
      data = file.read(144)
      self.RST_TimeStamp    = self.getString(data,   0, 18)
      self.RST_ScoreRecords = self.getString(data,  18, 88)
      self.RST_PlayerID     = self.getWORD(  data, 106)
      self.RST_Password     = self.decodePassword( self.getString(data, 108, 20) )

      self.RST_CheckShipBlock     = self.getDWORD(data, 128)
      self.RST_CheckPlanetBlock   = self.getDWORD(data, 132)
      self.RST_CheckStarbaseBlock = self.getDWORD(data, 136)
      self.RST_TurnNumber         = self.getWORD( data, 140)
      self.RST_CheckTimeStamp     = self.getWORD( data, 142)

      print "TimeStamp  : ",self.RST_TimeStamp
      print "PlayerID   : ",self.RST_PlayerID
      print "Password   : ",self.RST_Password
      print "Turn Number: ",self.RST_TurnNumber
    else:
      print "Warning: no GENx.DAT record in RST file."


    # section 8: VCRs
    if (ptrs[8] <= 0):
      print "\nNo VCR records in RST file"
    else:
      print "\nreading VCRs:"
      file.seek(ptrs[8])
      count = self.getWORD(file.read(2), 0)
      print count,"VRCs to read."
      for i in range(count):
        print "reading VCR",i
        data = file.read(100)
        vcr  = VCRClass(data)
        vcr.dump()
        self.battleVec[i] = vcr

    # other stuff:?

    file.close

#endclass

app = MainApp()

# app.loadRST("player1.rst")
# app.loadRST("rst20010827")
