
#
# visual contacts as defined in rst file
#

import rawdata
import re

class MessageClass(rawdata.rawdata):


  def __init__(self, data=""):

    self.data = ""
    self.typ       = ""
    self.playerID  = -1
    self.objectID  = -1
    self.subject   = ""
    self.is_planet =  0
    self.is_ship   =  0

    if (len( data ) > 0):
      self.initByRSTData( data )
    else:
      print "fehler! data hat nicht > 0 bytes!"

  def printMessage(self):
    print "\nMessage:"
    print "Msg-Typ : ",  self.typ
    print "PlayerID: ",  self.playerID
    print "objectID: ",  self.objectID
    print "subject : ",  self.subject
    print "Komplett:\n", self.data

  # (-z0047)<<< Sub Space Message >>>  (-> clear to colonize of ship 047, player 0)
  def analyzeFirstLine(self):
    match = re.match("^\(\-(.)(\d)(\d\d\d)\)(.*)$", self.firstline)
    if (len(match.groups()) == 4):
      self.typ      = match.group(1)
      self.playerID = int(match.group(2))
      self.objectID = int(match.group(3))
      self.subject  = match.group(4)

  def initByRSTData(self, data):
    self.data = ""
    self.firstline = ""  # capture the first line (-z0045)<<< ... >>>>
    first = 1
    for i in range(len(data)):
      o = ord(data[i])
      if o >= 13:
        o = o - 13 # decoding
      self.data = self.data + chr(o)

      if (1 == first):
        if (13 != o):
          self.firstline = self.firstline + chr(o)
        else:
          first = 0
      #if
    #for

    self.data = self.data.replace(chr(13), chr(10))
    self.analyzeFirstLine()
  #enddef

#endclass
