
#
# this is the planet class module for python planets:
#
import copy
import rawdata
from dataspace import DataSpace
from nativegovernmentclass import NativeGovernmentClass
from oreclass              import OreClass
from raceclass             import RaceClass

class PlanetClass(rawdata.rawdata):

  def __init__(self, data=""):
    self.oldData = DataSpace()  # the TRN is generated by diffing oldData and newData...
    self.newData = DataSpace()

    if (len( data ) == 85):
      self.initByRSTData( data )
    else:
      print "fehler! data hat nicht 85 bytes!"

  def getID(self):
    return self.oldData.id  # id must not change

  def dump(self):
    print "Dump eines Planeten:"
    print "ID  : ", self.getID()  # kann sich nicht ndern
    print "Gov : ", self.oldData.gov.getName()
    print "SPI : ", self.oldData.gov.getSPI()
    print "Race: ", self.oldData.race.getName()

  def initByRSTData(self, data):
    self.oldData.owner    = self.getWORD(data, 0)
    self.oldData.id       = self.getWORD(data, 2)
    self.oldData.fCode    = self.getFriendlyCode(data, 4)

    self.oldData.numMines     = self.getWORD(data,  7)# max = CLANS <= 200 ? CLANS : 200+sqrt(CLANS-200)
    self.oldData.numFactories = self.getWORD(data,  9)# max = CLANS <= 100 ? CLANS : 100+sqrt(CLANS-100)
    self.oldData.numDefenses  = self.getWORD(data, 11)# max = CLANS <=  50 ? CLANS :  50+sqrt(CLANS-50)

    self.oldData.minedOre = OreClass( 1,2,3,4 )
    self.oldData.minedOre = OreClass( self.getDWORD(data, 13), self.getDWORD(data, 17), self.getDWORD(data, 21), self.getDWORD(data, 25) )

    self.oldData.clans     = self.getDWORD(data, 29)
    self.oldData.colonists = long(100 * self.oldData.clans)
    self.oldData.supplies  = self.getDWORD(data, 33)
    self.oldData.credits   = self.getDWORD(data, 37)

    self.oldData.groundOre  = OreClass( self.getDWORD(data, 41), self.getDWORD(data, 45), self.getDWORD(data, 49), self.getDWORD(data, 53) )
#                        >4999           abundant
#                        1200..4999      very common
#                        600..1199       common
#                        100..599        rare
#                        1..99           very rare
#                        0               none

    self.oldData.oreDensity = OreClass( self.getWORD(data, 57), self.getWORD(data, 59), self.getWORD(data, 61), self.getWORD(data, 63) )
                        # 70..100 large masses    1 mine extracts 1 kt
                        # 40..69  concentrated    2 mines extract 1 kt
                        # 30..39  dispersed       3 mines extract 1 kt
                        # 10..29  scattered       5 mines extract 1 kt
                        # 0..9    very scattered  10 mines extract 1 kt
                # The amount of minerals extracted is (number of mines) *
                # (density) * (mining rate) / 10000, where "/10000"
                # compensates the fact that the mining rate and density are
                # both percentages. Double the mining rate on Reptilian
                # planets.

    self.oldData.colonistTax = self.getWORD(data, 65)
    self.oldData.nativetTax  = self.getWORD(data, 67)
                # Note that THost blocks taxes above 75% when hisssssing,
                # but allows up to 100% otherwise.

# 999: problem: negative numbers allowed: (method in rawdata.py is incorrect!!!!
    self.oldData.colonistHappiness = self.getSignedWORD(data, 69)
    self.oldData.nativeHappiness   = self.getSignedWORD(data, 71)
                        # 90..100 happy
                        # 70..89  calm
                        # 50..69  unhappy
                        # 40..49  very angry
                        # 20..39  rioting
                        # <20     fighting
                        # Tax collection possible for happiness>=40, population grows
                        # if >=70.


    self.oldData.gov = NativeGovernmentClass( self.getWORD(data, 73) )

    self.oldData.nativeClans =     self.getDWORD(data, 75)
    self.oldData.race = RaceClass( self.getWORD( data, 79) )

    self.oldData.temperature = self.getWORD(data, 81)
    self.oldData.buildbase    = self.getWORD(data, 83)


    self.newData = copy.deepcopy(self.oldData)
#endclass
