import sys
import libglade
from gtk import *

class plynetsGUIClass:

  bla = None

  def __init__( self,  xml_gui_filename, ref_to_MainApp ):
    self.ref_to_MainApp = ref_to_MainApp
    self.pixmap = None
    self.xml = libglade.GladeXML( xml_gui_filename )
    # if there is anything that needs to be added to the UI, we can access all
    # the widgets like this:
    # win = self.xml.get_widget('window1')
    drawing_area = self.xml.get_widget('drawingarea1')
    drawing_area.connect("expose_event",       self.on_drawingarea1_expose_event)
    drawing_area.connect("configure_event",    self.on_drawingarea1_configure_event)
    drawing_area.connect("button_press_event", self.on_drawingarea1_button_press_event)
    drawing_area.add_events(GDK.EXPOSURE_MASK | GDK.LEAVE_NOTIFY_MASK | GDK.BUTTON_PRESS_MASK )

    # we can connect to any of the signals named in the template:
    self.xml.signal_connect('close_window', mainquit)
    self.xml.signal_connect('on_ende1_activate', mainquit)
    # let's try to connect to a menu:
    self.xml.signal_connect("on_rst_laden1_activate", self.on_rst_laden1_activate, 1 )
    # mainloop()

  def testDrawXY(self, x, y):
    widget = self.xml.get_widget('drawingarea1')
    self.draw_brush( widget, x / 10, y / 10)

  def on_rst_laden1_activate(self,  widget, event):
    print "hallO"
    self.ref_to_MainApp.loadRST('rst20010827')

  def on_drawingarea1_configure_event(self,  widget, event):
    print "configure_event"
    if self.pixmap == None:
      win = widget.get_window()
      self.pixmap = create_pixmap(win, 400,400, -1)
      #  pixmap = create_pixmap(win, win.width, win.height, -1)
      draw_rectangle(self.pixmap, widget.get_style().white_gc, TRUE, 0, 0, 400, 400)
    return TRUE

  def on_drawingarea1_expose_event(self, widget, event):
    print "expose_event"
    if self.pixmap == None:
      self.on_drawingarea1_configure_event(widget, event)
    if self.pixmap == None:
      print "Fehler!"
    area = event.area
    print area[0],area[1],area[2],area[3]
    gc = widget.get_style().fg_gc[STATE_NORMAL]
    widget.draw_pixmap(gc, self.pixmap, area[0], area[1], area[0], area[1],  area[2], area[3] )
    return FALSE

  def draw_brush(self,  widget, x, y):
    rect = (x-5, y-5, 10, 10)
    draw_rectangle(self.pixmap, widget.get_style().black_gc, TRUE,
                       x-5, y-5, 10, 10)
    widget.queue_draw()

  def on_drawingarea1_button_press_event(self,  widget, event):
    print "button_press_event"
    if event.button == 1 and self.pixmap != None:
      self.draw_brush(widget, event.x, event.y)
    return TRUE

  def mainloop( self ):
    mainloop()

# endclass
