#
# helper methods for the extraction of WORDs and DWORDs
#

class rawdata:
  def getByteChar(self, data, pos):
    return data[pos]

  def getByteInt(self, data, pos):
    return int(data[pos])

  def getByteOrd(self, data, pos):
    return ord(data[pos])

  def getWORD(self, data, pos):
    return ord(data[pos]) + (256 * ord(data[pos+1]))

  def getSignedWORD(self, data, pos):
    w = self.getWORD(data,pos)
    if w > 32768:
      w = 65535 - w + 1   # 999 ob das so korrekt ist?
      w = -w
    return w
#

  def getDWORD(self, data, pos):
    return long( (256*256*self.getWORD( data, pos+2)) + self.getWORD( data, pos) )

  def getFriendlyCode(self, data, pos):
    str = data[pos] + data[pos+1] + data[pos+2]
    return str

  def getString(self, data, pos, len):
    str = ""
    for i in range(len):
      str = str + data[pos+i]
    return str

#endclass
