
#
# this is the ship class module for python planets:
#
import copy
import rawdata
from dataspace   import DataSpace
from oreclass    import OreClass
from cargoclass  import CargoClass

class ShipClass(rawdata.rawdata):

  def __init__(self, data=""):
    self.oldData = DataSpace()  # the TRN is generated by diffing oldData and newData...
    self.newData = DataSpace()
    
    if (len( data ) == 107):
      self.initByRSTData( data )
    else:
      print "fehler! data hat nicht 107 bytes!"

  def getName(self):
    return self.newData.name

  def getID(self):
    return self.oldData.id

  def dump(self):
    print "ID   :", self.oldData.id
    print "Owner:", self.oldData.owner
    print "FCode:", self.oldData.fCode
    print "X Y distX, distY:",self.oldData.x,self.oldData.y,self.oldData.distX,self.oldData.distY
    print "Cargo on Ship:"
    self.oldData.cargo.dump()
    print "Unload Cargo:"
    self.oldData.unloadCargo.dump()
    print "Transfer of Cargo to enemy ship:"
    self.oldData.transferCargo.dump()

  def initByRSTData(self, data):
    self.oldData.id       = self.getWORD(data, 0)
    self.oldData.owner    = self.getWORD(data, 2)
    self.oldData.fCode    = self.getFriendlyCode(data, 4)

    self.oldData.warp  = self.getSignedWORD(data,  7)
    self.oldData.distX = self.getSignedWORD(data,  9) # (destination-X minus X-position)
    self.oldData.distY = self.getSignedWORD(data, 11) # (-3000...3000)

    self.oldData.x = self.getWORD(data, 13)
    self.oldData.y = self.getWORD(data, 15)
                # Usually between 1 and 4000 or 1 and 10000. Ships with (X,Y)
                # = (0,0) should not appear, as this makes problems with the
                # SHIPXYx.DAT file and probably many clients.

    self.oldData.engineType = self.getWORD(data, 17) # (1..9, index into ENGSPEC.DAT)
    self.oldData.hullType   = self.getWORD(data, 19) # (1..105, index into HULLSPEC.DAT)
    self.oldData.beamType   = self.getWORD(data, 21) # (0 for none, 1..10 = index into BEAMSPEC.DAT else). See note
    self.oldData.numBeams   = self.getWORD(data, 23)
    self.oldData.numFighter = self.getWORD(data, 25)
    self.oldData.torpedoLauncherType = self.getWORD(data, 27)
    self.oldData.numTorpedos         = self.getWORD(data, 29)
    self.oldData.numTorpedoLaunchers = self.getWORD(data, 31)

    self.oldData.mission    = self.getWORD(data, 33)

    self.oldData.primaryEnemy = self.getWORD(data, 35)
    self.oldData.shipToTow    = self.getWORD(data, 37)
    self.oldData.damage       = self.getWORD(data, 39)
    self.oldData.crew         = self.getWORD(data, 41)

    self.oldData.name         = self.getString(data, 45,20)

    # CARGO on Ship:
    clans = self.getWORD(  data, 43)  # will go to cargo class...
    n     = self.getWORD(  data, 65 )
    t     = self.getWORD(  data, 67 )
    d     = self.getWORD(  data, 69 )
    m     = self.getWORD(  data, 71 )
    supplies = self.getWORD(  data, 73 )
    self.oldData.cargo = CargoClass( n,t,d,m, clans, supplies )

    # Unload Cargo to planet:
    n     = self.getWORD(  data, 75 )
    t     = self.getWORD(  data, 77 )
    d     = self.getWORD(  data, 79 )
    m     = self.getWORD(  data, 81 )
    clans = self.getWORD(  data, 83 )  # will go to cargo class...
    supplies = self.getWORD(  data, 85 )
    targetID = self.getWORD(  data, 87 )  # will go to cargo class...
    self.oldData.unloadCargo = CargoClass( n,t,d,m, clans, supplies, targetID )

    # Transfer to enemy ship:
    n     = self.getWORD(  data, 89 )
    t     = self.getWORD(  data, 91 )
    d     = self.getWORD(  data, 93 )
    m     = self.getWORD(  data, 95 )
    clans = self.getWORD(  data, 97 )  # will go to cargo class...
    supplies = self.getWORD(  data, 99 )
    targetID = self.getWORD(  data, 101)  # will go to cargo class...
    self.oldData.transferCargo = CargoClass( n,t,d,m, clans, supplies, targetID )

    self.oldData.interceptID = self.getWORD(  data, 103 )

    self.oldData.credits     = self.getWORD(  data, 105 )

    self.newData = copy.deepcopy(self.oldData)
#endclass
