
#
# ship coordinates as defined in rst file
#

import rawdata

class ShipCoordsClass(rawdata.rawdata):

  def __init__(self, data=""):
    self.x = 0
    self.y = 0
    self.owner = 0
    self.mass  = 0

    if (len( data ) == 8):
      self.initByRSTData( data )
    else:
      print "fehler! data hat nicht 8 bytes!"

  def getX(self):
    return self.x

  def getY(self):
    return self.y

  def getOwner(self):
    return self.owner

  def getMass(self):
    return self.mass

  def initByRSTData(self, data):
    self.x     = self.getWORD(data, 0)
    self.y     = self.getWORD(data, 2)
    self.owner = self.getWORD(data, 4)
    self.mass  = self.getWORD(data, 6)
#endclass
