
#
# this is the star base class module for python planets
#

import copy
import rawdata
from dataspace           import DataSpace
from storageclass        import StorageClass

class StarbaseClass(rawdata.rawdata):

  def __init__(self, data=""):
    self.oldData = DataSpace()  # the TRN is generated by diffing oldData and newData...
    self.newData = DataSpace()    
    if (len( data ) == 156):
      self.initByRSTData( data )
    else:
      print "fehler! data hat nicht 156 bytes!"

  def getID(self):
    return self.oldData.id

  def initByRSTData(self, data):
    self.oldData.id       = self.getWORD(data, 0) #= Id of planet with this base
    self.oldData.owner    = self.getWORD(data, 2) # 1..11
    self.oldData.defense  = self.getWORD(data, 4) # 0..200
    self.oldData.damage   = self.getWORD(data, 6) # 0..100

    # TECH-LEVELS:
    self.oldData.engineTechLevel  = self.getWORD(data,  8) # 1..10
    self.oldData.hullsTechLevel   = self.getWORD(data, 10) # 1..10
    self.oldData.weaponTechLevel  = self.getWORD(data, 12) # 1..10
    self.oldData.torpedoTechLevel = self.getWORD(data, 14) # 1..10: Tech upgrades: going from Tech N to N+1 costs 100*N mc.

    # STORAGE:
    self.oldData.engineStorage = StorageClass(9)
    for i in range(9):
      self.oldData.engineStorage.setCountAtPos( i+1 , self.getWORD(data, 16+(2*i)) )

    self.oldData.hullStorage = StorageClass(20)
    for i in range(20):
      self.oldData.hullStorage.setCountAtPos( i+1 , self.getWORD(data, 34+(2*i)) )

    self.oldData.beamWeaponStorage = StorageClass(10)
    for i in range(10):
      self.oldData.beamWeaponStorage.setCountAtPos( i+1 , self.getWORD(data, 74+(2*i)) )

    self.oldData.torpedoLauncherStorage = StorageClass(10)
    for i in range(10):
      self.oldData.torpedoLauncherStorage.setCountAtPos( i+1 , self.getWORD(data, 94+(2*i)) )

    self.oldData.torpedoStorage = StorageClass(10)
    for i in range(10):
      self.oldData.torpedoStorage.setCountAtPos( i+1 , self.getWORD(data, 114+(2*i)) )


    self.oldData.numFighters        = self.getWORD(data,134)
    self.oldData.idOfShipToRecycled = self.getWORD(data,136)
    self.oldData.actionForShip      = self.getWORD(data,138) # 0,1,2 = nothing,fix,recycle
    self.oldData.mission       = self.getWORD(data,140) # 1..6: primary order

    self.oldData.shipToBuild   = self.getWORD(data,142) # 0 = no build order

    self.oldData.engineType    = self.getWORD(data,144)
    self.oldData.beamType      = self.getWORD(data,146)
    self.oldData.beamCount     = self.getWORD(data,148)
    self.oldData.torpedoType   = self.getWORD(data,150)
    self.oldData.torpedoCount  = self.getWORD(data,152)

    self.oldData.shouldBeZero      = self.getWORD(data,154)

    # Now copy the data to "newdata". so now the old data is save, and
    # we can create the trn file later:
    self.newData = copy.deepcopy(self.oldData)
#endclass

