
#
# this is the ship class module for python planets:
#
import rawdata

#
# VCRClass and VCRObject:
#

class VCRObject(rawdata.rawdata):
  def __init__(self, data):
    self.name   = self.getString(data,0,20)
    self.damage = self.getWORD(data, 20)
    self.crew   = self.getWORD(data, 22)
    self.id     = self.getWORD(data, 24)
    self.owner  = self.getWORD(data, 26)
    self.picnum = self.getByteInt(data, 28)  # or: getByteChar, getByteOrd  ??

    self.unknown1 = self.getByteInt(data, 29) # Host: zero (Host addresses +28 as a WORD)
                                         # PHost: hull number of ship, 0 for planets
                                         # or in older PHosts.
    self.beamsType    = self.getWORD(data, 30)
    self.numBeams     = self.getWORD(data, 32)
    self.fighterTubes = self.getWORD(data, 34)
    self.torpedoType  = self.getWORD(data, 36)
    self.numFightersTorps     = self.getWORD(data, 38)
    self.numTorpedoLaunchers  = self.getWORD(data, 40)
  #enddef
#endclass


class VCRClass(rawdata.rawdata):

  def __init__(self, data=""):
    if (len( data ) == 100):
      self.initByRSTData( data )
    else:
      print "fehler! data hat nicht 100 bytes!"
      exit

  def initByRSTData(self, data):
    self.random_init       = self.getWORD(data,  0)
    self.signature         = self.getWORD(data,  2)
    self.temperature_code1 = self.getWORD(data,  4)
    self.battletype        = self.getWORD(data,  6) # 0 = ship:ship, 1=ship:planet
    self.mass_left         = self.getWORD(data,  8)
    self.mass_right        = self.getWORD(data, 10)

    self.leftObject   = VCRObject(self.getString(data, 12, 42))
    self.rightObject  = VCRObject(self.getString(data, 54, 42))

    self.shieldLeft   = self.getWORD(data, 96)
    self.shieldRight  = self.getWORD(data, 98)
  #enddef

  def dump(self):
    if self.battleType == 0:
      right = "Ship"
    else:
      right = "Planet"
    print "Battle with Ship", leftObject.id, "and", right, rightObject.id
  #enddef

#endclass
