
#
# visual contacts as defined in rst file
#

import rawdata

class VisualContactClass(rawdata.rawdata):

  def __init__(self, data=""):
    if (len( data ) == 34):
      self.initByRSTData( data )
    else:
      print "fehler! data hat nicht 34 bytes!"

  def getID(self):
    return self.id

  def getOwner(self):
    return self.owner

  def getName(self):
    return self.name

  def getX(self):
    return self.x

  def getY(self):
    return self.y


  def getHullType(self):
    return self.hullType

  def initByRSTData(self, data):
    self.id       = self.getWORD(data, 0)
    self.owner    = self.getWORD(data, 2)
    self.warp     = self.getWORD(data, 4)
    self.x        = self.getWORD(data, 6)
    self.y        = self.getWORD(data, 8)
    self.hullType = self.getWORD(data,10)
    self.heading  = self.getWORD(data,12)
    self.name     = self.getString(data, 14,20)
#endclass
