
#
# class for XYPLAN.DAT / PLANETS.NM - elements:
#
# all instances will be collected in an array[planetID]->xyplanclass
#
import rawdata

class XYPlanClass(rawdata.rawdata):

  def __init__(self, data, name):   # xyplan.dat: x,y,owner (6 bytes), planets.nm: string[20]
    self.x   = 0
    self.y   = 0
    # self.owner in xyplan.dat is always zero (0)
    self.name= "<unknown>"

    if (len( data ) == 6):
      self.initByRSTData( data )
      self.name = name
    else:
      print "fehler! data hat nicht 85 bytes!"

  def dump(self):
    print "x y name: ",self.x, self.y, self.name

  def initByRSTData(self, data):
    self.x      = self.getWORD(data, 0)
    self.y      = self.getWORD(data, 2)
    # self.owner = self.getWORD(data, 4) == 0

  #

#endclass
